<?php
session_start();

/**
 * Check if user is logged in, redirect to login if not
 */
function requireLogin() {
    if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
        header('Location: login.php');
        exit;
    }
}

/**
 * Check if user is admin, redirect if not
 */
function requireAdmin() {
    requireLogin();
    if ($_SESSION['role'] !== 'admin') {
        header('Location: dashboard.php');
        exit;
    }
}

/**
 * Check if user is sales rep, redirect if not
 */
function requireSalesRep() {
    requireLogin();
    if ($_SESSION['role'] !== 'sales_rep') {
        header('Location: dashboard.php');
        exit;
    }
}
