<?php
require_once "../config/config.php";
require_once "../includes/auth_check.php";
requireLogin();

$conn = getDbConnection();

$user_id = $_SESSION['user_id'];
$current_password = $new_password = $confirm_password = "";
$current_password_err = $new_password_err = $confirm_password_err = "";
$success_message = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $current_password = trim($_POST['current_password']);
    $new_password = trim($_POST['new_password']);
    $confirm_password = trim($_POST['confirm_password']);

    // Validate current password
    if (empty($current_password)) {
        $current_password_err = "Please enter your current password.";
    } else {
        // Fetch existing password hash
        $stmt = $conn->prepare("SELECT password_hash FROM users WHERE user_id = ?");
        $stmt->bind_param("i", $user_id);
        $stmt->execute();
        $stmt->bind_result($hashed_password);
        if ($stmt->fetch()) {
            if (!password_verify($current_password, $hashed_password)) {
                $current_password_err = "Current password is incorrect.";
            }
        } else {
            $current_password_err = "User not found.";
        }
        $stmt->close();
    }

    // Validate new password
    if (empty($new_password)) {
        $new_password_err = "Please enter a new password.";
    } elseif (strlen($new_password) < 6) {
        $new_password_err = "New password must be at least 6 characters.";
    }

    // Confirm new password
    if (empty($confirm_password)) {
        $confirm_password_err = "Please confirm the new password.";
    } elseif ($new_password !== $confirm_password) {
        $confirm_password_err = "New password and confirmation do not match.";
    }

    // Update password if no errors
    if (empty($current_password_err) && empty($new_password_err) && empty($confirm_password_err)) {
        $new_hashed_password = password_hash($new_password, PASSWORD_DEFAULT);
        $update = $conn->prepare("UPDATE users SET password_hash = ? WHERE user_id = ?");
        $update->bind_param("si", $new_hashed_password, $user_id);
        if ($update->execute()) {
            $success_message = "Password changed successfully.";
        } else {
            $success_message = "Error updating password, please try again.";
        }
        $update->close();
    }
}

$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <title>Change Password - Adwenpa Pharma</title>
    <link rel="stylesheet" href="css/bootstrap.min.css" />
    <style>.wrapper{max-width:450px; margin:30px auto;}</style>
</head>
<body>
<div class="wrapper">
    <h2>Change Password</h2>
    <?php if ($success_message): ?>
        <div class="alert alert-info"><?= htmlspecialchars($success_message) ?></div>
    <?php endif; ?>
    <form method="post" action="change_password.php">
        <div class="form-group">
            <label>Current Password</label>
            <input type="password" name="current_password" class="form-control <?= $current_password_err ? 'is-invalid' : '' ?>" />
            <div class="invalid-feedback"><?= htmlspecialchars($current_password_err) ?></div>
        </div>
        <div class="form-group">
            <label>New Password</label>
            <input type="password" name="new_password" class="form-control <?= $new_password_err ? 'is-invalid' : '' ?>" />
            <div class="invalid-feedback"><?= htmlspecialchars($new_password_err) ?></div>
        </div>
        <div class="form-group">
            <label>Confirm New Password</label>
            <input type="password" name="confirm_password" class="form-control <?= $confirm_password_err ? 'is-invalid' : '' ?>" />
            <div class="invalid-feedback"><?= htmlspecialchars($confirm_password_err) ?></div>
        </div>
        <button type="submit" class="btn btn-primary">Update Password</button>
        <a href="dashboard.php" class="btn btn-secondary ml-2">Cancel</a>
    </form>
</div>
</body>
</html>
