<?php
require_once __DIR__ . "/../config/config.php";

session_start();
require_once "../includes/role_helpers.php";
requireLogin();

$conn = getDbConnection();

// Total Users
$res = $conn->query("SELECT COUNT(*) AS total FROM users");
if (!$res) die("MySQL query error (users count): " . $conn->error);
$total_users = $res->fetch_assoc()['total'];

// Total Products (merged medicines)
$res = $conn->query("SELECT COUNT(*) AS total FROM products");
if (!$res) die("MySQL query error (products count): " . $conn->error);
$total_products = $res->fetch_assoc()['total'];

// Total Sales
$res = $conn->query("SELECT COUNT(*) AS total FROM sales");
if (!$res) die("MySQL query error (sales count): " . $conn->error);
$total_sales = $res->fetch_assoc()['total'];

// Total Prescriptions
$res = $conn->query("SELECT COUNT(*) AS total FROM prescriptions");
if (!$res) die("MySQL query error (prescriptions count): " . $conn->error);
$total_prescriptions = $res->fetch_assoc()['total'];

// Total Stock Items = count of products with stock_quantity > 0
$res = $conn->query("SELECT COUNT(*) AS total FROM products WHERE stock_quantity > 0");
if (!$res) die("MySQL query error (stock count): " . $conn->error);
$total_stock = $res->fetch_assoc()['total'];

// Total Suppliers
$res = $conn->query("SELECT COUNT(*) AS total FROM suppliers");
if (!$res) die("MySQL query error (suppliers count): " . $conn->error);
$total_suppliers = $res->fetch_assoc()['total'];

// Total Purchase Orders
$res = $conn->query("SELECT COUNT(*) AS total FROM purchase_orders");
if (!$res) die("MySQL query error (purchase orders count): " . $conn->error);
$total_purchase_orders = $res->fetch_assoc()['total'];

// Total Branches (new)
$res = $conn->query("SELECT COUNT(*) AS total FROM branches");
if (!$res) die("MySQL query error (branches count): " . $conn->error);
$total_branches = $res->fetch_assoc()['total'];

// Low Stock Alerts count (products with stock_quantity less than threshold)
$low_stock_threshold = 10;
$res = $conn->query("SELECT COUNT(*) AS total FROM products WHERE stock_quantity < $low_stock_threshold");
if (!$res) die("MySQL query error (low stock count): " . $conn->error);
$low_stock_count = $res->fetch_assoc()['total'];

// Inventory additional stats
$res = $conn->query("SELECT IFNULL(SUM(stock_quantity), 0) AS total_inventory_quantity FROM products");
if (!$res) die("MySQL query error (total inventory quantity): " . $conn->error);
$total_inventory_quantity = $res->fetch_assoc()['total_inventory_quantity'];

$res = $conn->query("SELECT COUNT(*) AS low_stock_items FROM products WHERE stock_quantity < $low_stock_threshold");
if (!$res) die("MySQL query error (low stock items count): " . $conn->error);
$low_stock_items = $res->fetch_assoc()['low_stock_items'];

// Recent activities
$recent_activities_query = "
    SELECT 
        'sale' AS type, 
        s.sale_date AS activity_time, 
        CONCAT('Sale of ', p.product_name, ' by ', u.username) AS description
    FROM sales s
    JOIN sale_items si ON si.sale_id = s.sale_id
    JOIN products p ON si.product_id = p.product_id
    JOIN users u ON s.sales_rep_id = u.user_id

    UNION

    SELECT 
        'prescription', 
        p.prescription_date, 
        CONCAT('Prescription for ', p.patient_name, ' by ', u.username)
    FROM prescriptions p
    JOIN users u ON p.sales_rep_id = u.user_id

    UNION

    SELECT 
        'purchase_order',
        po.order_date,
        CONCAT('Purchase order placed to ', s.name)
    FROM purchase_orders po
    JOIN suppliers s ON po.supplier_id = s.supplier_id

    UNION

    SELECT 
        'user', 
        u.created_at, 
        CONCAT('User registered: ', u.username)
    FROM users u

    ORDER BY activity_time DESC
    LIMIT 5
";

$recent_activities = $conn->query($recent_activities_query);
if (!$recent_activities) die("MySQL query error (recent activities): " . $conn->error);

// Recent audit logs for dashboard
$recent_audit_logs = $conn->query("
    SELECT al.*, u.username 
    FROM audit_logs al 
    JOIN users u ON al.user_id = u.user_id 
    ORDER BY al.created_at DESC
    LIMIT 5
");
if (!$recent_audit_logs) die("MySQL query error (recent audit logs): " . $conn->error);

$username = $_SESSION["username"];
$role = $_SESSION["role"];

$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <title>Dashboard - Adwenpa Pharma</title>
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
    <link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-icons/1.13.0/font/bootstrap-icons.min.css" rel="stylesheet" />
    <style>
        body { min-height: 100vh; display: flex; flex-direction: column; }
        .sidebar { height: 100vh; position: fixed; top: 0; left: 0; width: 220px; background-color: #0d6efd; color: white; padding-top: 60px; flex-shrink: 0; z-index: 1040; }
        .sidebar a { color: white; text-decoration: none; padding: 12px 20px; display: flex; align-items: center; transition: background-color 0.2s, color 0.2s; position: relative; }
        .sidebar a:hover, .sidebar a.active { background-color: #084298; color: white; }
        .sidebar a i { margin-right: 10px; font-size: 1.25rem; }
        .sidebar a::after { content: ''; position: absolute; left: 15px; bottom: 7px; width: 0; height: 2px; background: #fff; transition: width 0.3s; }
        .sidebar a:hover::after, .sidebar a.active::after { width: 60%; }
        main.content { margin-left: 220px; padding: 30px 20px 20px 20px; margin-top: 70px; flex-grow: 1; }
        .welcome { margin-bottom: 30px; animation: fade-in 1.2s cubic-bezier(.75,-0.5,0,1.5); }
        .card { transition: transform 0.25s, box-shadow 0.25s, opacity 1s; opacity: 0; transform: translateY(40px); }
        .card.loaded { opacity: 1; transform: none; }
        .card:hover { transform: translateY(-4px) scale(1.03); box-shadow: 0 8px 24px rgba(13, 110, 253, 0.08); z-index: 1; }
        .card-icon { font-size: 2.5rem; color: #0d6efd; opacity: 0.17; position: absolute; top: 20px; right: 20px; pointer-events: none; }
        @media (max-width: 991.98px) { .sidebar { width: 100%; height: auto; position: inherit; padding-top: 0; } main.content { margin-left: 0; margin-top: 80px; } }
        .counter { font-weight: 700; font-size: 2.5rem; }
    </style>
</head>
<body>

<nav class="navbar navbar-expand-lg navbar-dark bg-primary fixed-top">
    <div class="container-fluid">
        <a class="navbar-brand fw-bold" href="#">Adwenpa Pharma</a>

        <div class="dropdown ms-auto">
            <a href="#" class="d-flex align-items-center text-white text-decoration-none dropdown-toggle" id="userMenu" data-bs-toggle="dropdown" aria-expanded="false">
                <i class="bi bi-person-circle fs-4 me-2"></i>
                <?= htmlspecialchars($username) ?>
            </a>
            <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="userMenu">
                <li><a class="dropdown-item" href="change_password.php">Change Password</a></li>
                <li><hr class="dropdown-divider"></li>
                <li><a class="dropdown-item" href="logout.php">Logout</a></li>
            </ul>
        </div>
    </div>
</nav>

<div class="sidebar d-none d-lg-block">
    <a href="dashboard.php" class="active"><i class="bi bi-speedometer2"></i> Dashboard</a>
    <a href="manage_users.php"><i class="bi bi-people"></i> Manage Users</a>
    <a href="stock_management.php"><i class="bi bi-box-seam"></i> Stock Management</a>
    <a href="branches.php"><i class="bi bi-diagram-3"></i> Branches</a>
    <a href="suppliers.php"><i class="bi bi-truck"></i> Suppliers</a>
    <a href="purchase_orders.php"><i class="bi bi-card-list"></i> Purchase Orders</a>
    <a href="reports.php"><i class="bi bi-bar-chart-line"></i> Reports</a>
    <a href="manage_prescriptions.php"><i class="bi bi-file-medical"></i> Prescriptions</a>
    <a href="pos.php"><i class="bi bi-cash-stack"></i> POS Sales</a>
    <a href="staff_sales_summary.php"><i class="bi bi-graph-up"></i> Staff Sales Report</a>
    <a href="audit_logs.php"><i class="bi bi-file-earmark-text"></i> Audit Logs</a>
    <a href="backup.php"><i class="bi bi-hdd-network"></i> Backup</a>
    <a href="restore.php"><i class="bi bi-hdd-stack"></i> Restore</a>
</div>

<main class="content">
    <div class="welcome">
        <h1>Welcome, <?= htmlspecialchars($username) ?>!</h1>
        <p>You are logged in as a <strong><?= htmlspecialchars($role) ?></strong>.</p>
    </div>

    <!-- Statistic Counters -->
    <div class="row text-center mb-4">

        <div class="col-md-2 mb-3">
            <div class="card shadow-sm border-0">
                <div class="card-body">
                    <div class="counter text-primary" data-target="<?= $total_products ?>">0</div>
                    <div>Products</div>
                </div>
            </div>
        </div>

        <div class="col-md-2 mb-3">
            <div class="card shadow-sm border-0">
                <div class="card-body">
                    <div class="counter text-success" data-target="<?= $total_users ?>">0</div>
                    <div>Users</div>
                </div>
            </div>
        </div>

        <div class="col-md-2 mb-3">
            <div class="card shadow-sm border-0">
                <div class="card-body">
                    <div class="counter text-info" data-target="<?= $total_sales ?>">0</div>
                    <div>Sales</div>
                </div>
            </div>
        </div>

        <div class="col-md-2 mb-3">
            <div class="card shadow-sm border-0">
                <div class="card-body">
                    <div class="counter text-danger" data-target="<?= $total_prescriptions ?>">0</div>
                    <div>Prescriptions</div>
                </div>
            </div>
        </div>

        <div class="col-md-2 mb-3">
            <div class="card shadow-sm border-0">
                <div class="card-body">
                    <div class="counter text-warning" data-target="<?= $total_stock ?>">0</div>
                    <div>Stock Items</div>
                </div>
            </div>
        </div>

        <div class="col-md-2 mb-3">
            <div class="card shadow-sm border-0">
                <div class="card-body">
                    <div class="counter text-primary" data-target="<?= $total_inventory_quantity ?>">0</div>
                    <div>Total Inventory Quantity</div>
                </div>
            </div>
        </div>

        <div class="col-md-2 mb-3">
            <div class="card shadow-sm border-0">
                <div class="card-body">
                    <div class="counter text-danger" data-target="<?= $low_stock_items ?>">0</div>
                    <div>Low Stock Items</div>
                </div>
            </div>
        </div>

        <div class="col-md-2 mb-3">
            <div class="card shadow-sm border-0">
                <div class="card-body">
                    <div class="counter text-primary" data-target="<?= $total_branches ?>">0</div>
                    <div>Branches</div>
                </div>
            </div>
        </div>

        <div class="col-md-2 mb-3">
            <div class="card shadow-sm border-0">
                <div class="card-body">
                    <div class="counter text-danger" data-target="<?= $low_stock_count ?>">0</div>
                    <div>Low Stock Alerts</div>
                </div>
            </div>
        </div>

        <div class="col-md-2 mb-3">
            <div class="card shadow-sm border-0">
                <div class="card-body">
                    <div class="counter text-secondary" data-target="<?= $total_suppliers ?>">0</div>
                    <div>Suppliers</div>
                </div>
            </div>
        </div>

        <div class="col-md-2 mb-3">
            <div class="card shadow-sm border-0">
                <div class="card-body">
                    <div class="counter text-secondary" data-target="<?= $total_purchase_orders ?>">0</div>
                    <div>Purchase Orders</div>
                </div>
            </div>
        </div>

    </div>

    <!-- Recent Activity Feed -->
    <div class="mb-4">
        <h5 class="mb-3">Recent Activity</h5>
        <ul class="list-group">
            <?php while($activity = $recent_activities->fetch_assoc()): ?>
                <li class="list-group-item d-flex align-items-center">
                    <span class="me-3 fs-4">
                      <?php
                        if ($activity['type'] == 'sale') echo '<i class="bi bi-currency-dollar text-success"></i>';
                        elseif ($activity['type'] == 'prescription') echo '<i class="bi bi-clipboard-check text-info"></i>';
                        elseif ($activity['type'] == 'purchase_order') echo '<i class="bi bi-card-list text-primary"></i>';
                        elseif ($activity['type'] == 'user') echo '<i class="bi bi-person-plus text-primary"></i>';
                      ?>
                    </span>
                    <div>
                        <?= htmlspecialchars($activity['description']) ?><br>
                        <small class="text-muted"><?= date('M d, Y H:i', strtotime($activity['activity_time'])) ?></small>
                    </div>
                </li>
            <?php endwhile; ?>
        </ul>
    </div>

    <!-- Recent Audit Logs Section -->
    <div class="mb-4">
        <h5 class="mb-3">Recent Audit Logs</h5>
        <ul class="list-group">
            <?php while($log = $recent_audit_logs->fetch_assoc()): ?>
                <li class="list-group-item">
                    <div>
                        <small class="text-muted"><?= htmlspecialchars($log['created_at']) ?></small><br />
                        <strong><?= htmlspecialchars($log['username']) ?></strong>: 
                        <?= htmlspecialchars($log['action']) ?><br />
                        <small><?= nl2br(htmlspecialchars($log['details'])) ?></small>
                    </div>
                </li>
            <?php endwhile; ?>
        </ul>
        <a href="audit_logs.php" class="btn btn-link mt-3">View all audit logs</a>
    </div>

    <!-- Dashboard Cards -->
    <div class="row g-4">

        <div class="col-md-3">
            <a href="manage_users.php" class="text-decoration-none">
                <div class="card position-relative shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">Manage Users</h5>
                        <p class="card-text">Add, edit, or remove users with role-based permissions.</p>
                        <i class="bi bi-people card-icon"></i>
                    </div>
                </div>
            </a>
        </div>

        <div class="col-md-3">
            <a href="stock_management.php" class="text-decoration-none">
                <div class="card position-relative shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">Stock Management</h5>
                        <p class="card-text">Manage stock levels and product details efficiently.</p>
                        <i class="bi bi-box-seam card-icon"></i>
                    </div>
                </div>
            </a>
        </div>

        <div class="col-md-3">
            <a href="branches.php" class="text-decoration-none">
                <div class="card position-relative shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">Branches</h5>
                        <p class="card-text">Manage and configure shop branches locations.</p>
                        <i class="bi bi-diagram-3 card-icon"></i>
                    </div>
                </div>
            </a>
        </div>

        <div class="col-md-3">
            <a href="suppliers.php" class="text-decoration-none">
                <div class="card position-relative shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">Suppliers</h5>
                        <p class="card-text">Manage supplier details and contacts.</p>
                        <i class="bi bi-truck card-icon"></i>
                    </div>
                </div>
            </a>
        </div>

        <div class="col-md-3">
            <a href="purchase_orders.php" class="text-decoration-none">
                <div class="card position-relative shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">Purchase Orders</h5>
                        <p class="card-text">Manage supplier purchase orders and inventory stock updates.</p>
                        <i class="bi bi-card-list card-icon"></i>
                    </div>
                </div>
            </a>
        </div>

        <div class="col-md-3">
            <a href="manage_prescriptions.php" class="text-decoration-none">
                <div class="card position-relative shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">Prescriptions</h5>
                        <p class="card-text">View and manage patient prescriptions efficiently.</p>
                        <i class="bi bi-file-medical card-icon"></i>
                    </div>
                </div>
            </a>
        </div>

        <div class="col-md-3">
            <a href="pos.php" class="text-decoration-none">
                <div class="card position-relative shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">POS Sales</h5>
                        <p class="card-text">Process sales at the point of sale terminal effectively.</p>
                        <i class="bi bi-cash-stack card-icon"></i>
                    </div>
                </div>
            </a>
        </div>

        <div class="col-md-3">
            <a href="reports.php" class="text-decoration-none">
                <div class="card position-relative shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">Reports</h5>
                        <p class="card-text">View sales reports with charts and advanced filters.</p>
                        <i class="bi bi-bar-chart-line card-icon"></i>
                    </div>
                </div>
            </a>
        </div>

        <div class="col-md-3">
            <a href="audit_logs.php" class="text-decoration-none">
                <div class="card position-relative shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">Audit Logs</h5>
                        <p class="card-text">Review recent system actions and events.</p>
                        <i class="bi bi-file-earmark-text card-icon"></i>
                    </div>
                </div>
            </a>
        </div>

        <div class="col-md-3">
            <a href="backup.php" class="text-decoration-none">
                <div class="card position-relative shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">Backup</h5>
                        <p class="card-text">Create database backups manually.</p>
                        <i class="bi bi-hdd-network card-icon"></i>
                    </div>
                </div>
            </a>
        </div>

        <div class="col-md-3">
            <a href="restore.php" class="text-decoration-none">
                <div class="card position-relative shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">Restore</h5>
                        <p class="card-text">Restore database from backup files.</p>
                        <i class="bi bi-hdd-stack card-icon"></i>
                    </div>
                </div>
            </a>
        </div>

        <!-- Add the inventory.php link card -->
        <div class="col-md-3">
            <a href="inventory.php" class="text-decoration-none">
                <div class="card position-relative shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">Inventory Management</h5>
                        <p class="card-text">Manage inventory products and stock levels.</p>
                        <i class="bi bi-box-seam card-icon"></i>
                    </div>
                </div>
            </a>
        </div>

    </div>

</main>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Animate cards
    document.querySelectorAll('.card').forEach((card, i) => {
        setTimeout(() => card.classList.add('loaded'), 150 + i * 120);
    });

    // Animated counters for stats
    document.querySelectorAll('.counter').forEach(counter => {
        const updateCount = () => {
            const target = +counter.getAttribute('data-target');
            const count = +counter.innerText;
            const increment = Math.ceil(target / 100);
            if (count < target) {
                counter.innerText = Math.min(count + increment, target);
                setTimeout(updateCount, 25);
            } else {
                counter.innerText = target;
            }
        };
        updateCount();
    });
});
</script>

</body>
</html>
