<footer class="footer" id="footer">
    Developed by <a href="#" id="consultLink" style="color:#ddd;text-decoration:underline;cursor:pointer;">Adwenpa Consults</a>.
</footer>

<!-- Email Form Modal -->
<div id="emailFormModal" style="display:none;position:fixed;top:0;left:0;width:100vw;height:100vh;background:rgba(0,0,0,0.6);z-index:30;justify-content:center;align-items:center;">
    <form id="emailForm" style="background:#fff;color:#000;padding:20px;border-radius:10px;max-width:400px;width:90%;">
        <h5>Send Email to Adwenpa Consults</h5>
        <div class="mb-3">
            <label for="senderName" class="form-label">Your Name</label>
            <input type="text" id="senderName" name="senderName" class="form-control" placeholder="Your name" required />
        </div>
        <div class="mb-3">
            <label for="senderEmail" class="form-label">Your Email</label>
            <input type="email" id="senderEmail" name="senderEmail" class="form-control" placeholder="Your email" required />
        </div>
        <div class="mb-3">
            <label for="messageBody" class="form-label">Message</label>
            <textarea id="messageBody" name="messageBody" class="form-control" rows="4" placeholder="Write your message here..." required></textarea>
        </div>
        <div class="d-flex justify-content-between">
            <button type="submit" class="btn btn-primary">Send</button>
            <button type="button" id="cancelBtn" class="btn btn-secondary">Cancel</button>
        </div>
        <div id="emailStatus" style="margin-top:10px;"></div>
    </form>
</div>

<script>
document.getElementById('consultLink').addEventListener('click', function(e) {
    e.preventDefault();
    document.getElementById('emailFormModal').style.display = 'flex';
});

document.getElementById('cancelBtn').addEventListener('click', function() {
    document.getElementById('emailFormModal').style.display = 'none';
    document.getElementById('emailStatus').innerText = '';
    document.getElementById('emailForm').reset();
});

// Handle form submission with AJAX to send email
document.getElementById('emailForm').addEventListener('submit', function(e) {
    e.preventDefault();
    const statusEl = document.getElementById('emailStatus');
    statusEl.style.color = 'black';
    statusEl.innerText = 'Sending...';

    const data = new FormData(this);

    fetch('send_email.php', {
        method: 'POST',
        body: data
    }).then(response => response.json())
      .then(result => {
        if (result.success) {
            statusEl.style.color = 'green';
            statusEl.innerText = 'Email sent successfully!';
            setTimeout(() => {
                document.getElementById('emailFormModal').style.display = 'none';
                statusEl.innerText = '';
                document.getElementById('emailForm').reset();
            }, 2000);
        } else {
            statusEl.style.color = 'red';
            statusEl.innerText = 'Error: ' + result.message;
        }
      }).catch(() => {
          statusEl.style.color = 'red';
          statusEl.innerText = 'Network error. Please try again.';
      });
});
</script>
