<?php
require_once "../config/config.php";
session_start();
require_once "../includes/role_helpers.php";
requireAdmin();

$dbHost = 'localhost';
$dbUser = 'root';
$dbPass = '';
$dbName = 'adwenpa_pharma';

$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['backup_file'])) {
    $upload = $_FILES['backup_file'];

    if ($upload['error'] === UPLOAD_ERR_OK) {
        $tmpFile = $upload['tmp_name'];

        // Move uploaded file to temporary fixed location for restore
        $restoreFile = __DIR__ . '/backups/restore_temp.sql';
        move_uploaded_file($tmpFile, $restoreFile);

        // Run mysql restore command
        $command = "mysql --user={$dbUser} --password={$dbPass} --host={$dbHost} {$dbName} < {$restoreFile}";

        exec($command, $output, $return_var);

        // Delete temporary restore file
        unlink($restoreFile);

        if ($return_var === 0) {
            $message = "Restore successful from uploaded file.";
        } else {
            $message = "Restore failed.";
        }
    } else {
        $message = "File upload error.";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <title>Database Restore - Adwenpa Pharma</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
</head>
<body>
<div class="container my-4">
    <h2>Database Restore</h2>
    <?php if ($message): ?>
        <div class="alert alert-info"><?= htmlspecialchars($message) ?></div>
    <?php endif; ?>

    <form method="post" enctype="multipart/form-data" class="mb-3">
        <div class="mb-3">
            <label for="backup_file" class="form-label">Select Backup SQL File to Restore</label>
            <input type="file" name="backup_file" id="backup_file" accept=".sql" class="form-control" required />
        </div>
        <button type="submit" class="btn btn-danger" onclick="return confirm('Warning: Restoring a database will overwrite current data. Continue?')">
            Restore Database
        </button>
        <a href="dashboard.php" class="btn btn-secondary ms-2">Back to Dashboard</a>
    </form>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
