<?php
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method.']);
    exit;
}

$to = 'adwenpaconsults@yahoo.com';
$senderName = trim($_POST['senderName'] ?? '');
$senderEmail = trim($_POST['senderEmail'] ?? '');
$messageBody = trim($_POST['messageBody'] ?? '');

if (!$senderName || !$senderEmail || !$messageBody) {
    echo json_encode(['success' => false, 'message' => 'All fields are required.']);
    exit;
}
if (!filter_var($senderEmail, FILTER_VALIDATE_EMAIL)) {
    echo json_encode(['success' => false, 'message' => 'Invalid email address.']);
    exit;
}

$subject = "Message from $senderName via Adwenpa Consults website";
$headers = "From: $senderName <$senderEmail>\r\n";
$headers .= "Reply-To: $senderEmail\r\n";
$headers .= "Content-Type: text/plain; charset=utf-8\r\n";

$fullMessage = "Name: $senderName\nEmail: $senderEmail\n\nMessage:\n$messageBody";

if (mail($to, $subject, $fullMessage, $headers)) {
    echo json_encode(['success' => true]);
} else {
    echo json_encode(['success' => false, 'message' => 'Failed to send email.']);
}
