<?php
session_start();
require_once "../includes/role_helpers.php";
requireAdmin();
require_once "../config/config.php";

$conn = getDbConnection();

$success_msg = $error_msg = "";

// Update stock quantity
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $product_id = intval($_POST['product_id'] ?? 0);
    $quantity = intval($_POST['quantity'] ?? 0);

    if ($product_id > 0 && $quantity >= 0) {
        $stmt = $conn->prepare("INSERT INTO stock (product_id, quantity) VALUES (?, ?) ON DUPLICATE KEY UPDATE quantity = ?");
        $stmt->bind_param("iii", $product_id, $quantity, $quantity);
        if ($stmt->execute()) {
            $success_msg = "Stock updated.";
        } else {
            $error_msg = "Error updating stock.";
        }
        $stmt->close();
    } else {
        $error_msg = "Enter valid product and quantity.";
    }
}

// Fetch products with stock quantity (left join for stock)
$sql = "
    SELECT p.product_id, p.product_name, IFNULL(s.quantity, 0) AS stock_quantity
    FROM products p
    LEFT JOIN stock s ON p.product_id = s.product_id
    ORDER BY p.product_name
";

$products = $conn->query($sql);
$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <title>Stock Management - Admin</title>
    <link rel="stylesheet" href="css/bootstrap.min.css" />
    <style>.container{max-width:700px;margin:30px auto;}</style>
</head>
<body>
<div class="container">
    <h2>Stock Management</h2>
    <?php if ($success_msg): ?>
        <div class="alert alert-success"><?= htmlspecialchars($success_msg) ?></div>
    <?php elseif ($error_msg): ?>
        <div class="alert alert-danger"><?= htmlspecialchars($error_msg) ?></div>
    <?php endif; ?>

    <form method="post" class="form-inline mb-3">
        <select name="product_id" class="form-control mr-2" required>
            <option value="">Select Product</option>
            <?php while ($prod = $products->fetch_assoc()): ?>
                <option value="<?= $prod['product_id'] ?>"><?= htmlspecialchars($prod['product_name']) ?></option>
            <?php endwhile; ?>
        </select>
        <input type="number" name="quantity" class="form-control mr-2" min="0" placeholder="Quantity" required />
        <button type="submit" class="btn btn-primary">Update Stock</button>
    </form>

    <table class="table table-striped table-bordered">
        <thead><tr><th>Product</th><th>Quantity in Stock</th></tr></thead>
        <tbody>
            <?php
            // Re-fetch products with stock after potential update
            $conn = getDbConnection();
            $stockResult = $conn->query($sql);
            while ($row = $stockResult->fetch_assoc()): ?>
            <tr>
                <td><?= htmlspecialchars($row['product_name']) ?></td>
                <td><?= htmlspecialchars($row['stock_quantity']) ?></td>
            </tr>
            <?php endwhile; 
            $conn->close(); ?>
        </tbody>
    </table>
</div>
</body>
</html>
