<?php
require_once "../config/config.php";
session_start();
require_once "../includes/role_helpers.php";
requireLogin();

if (!isset($_GET['id'])) {
    header('Location: manage_prescriptions.php');
    exit;
}

$prescription_id = intval($_GET['id']);

$conn = getDbConnection();

$sql = "
SELECT p.prescription_id, p.patient_name, p.prescription_date, p.notes, u.username
FROM prescriptions p
JOIN users u ON p.sales_rep_id = u.user_id
WHERE p.prescription_id = ?
LIMIT 1
";

$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $prescription_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    $stmt->close();
    $conn->close();
    header('Location: manage_prescriptions.php');
    exit;
}

$prescription = $result->fetch_assoc();
$stmt->close();
$conn->close();

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <title>View Prescription - Adwenpa Pharma</title>
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
</head>
<body>

<nav class="navbar navbar-expand-lg navbar-dark bg-primary">
    <div class="container-fluid">
        <a class="navbar-brand" href="dashboard.php">Adwenpa Pharma</a>
    </div>
</nav>

<div class="container my-4">
    <a href="manage_prescriptions.php" class="btn btn-secondary mb-3">&larr; Back to Prescriptions</a>

    <h2>Prescription Details</h2>

    <div class="card">
        <div class="card-body">
            <h5 class="card-title">Patient: <?= htmlspecialchars($prescription['patient_name']) ?></h5>
            <p><strong>Prescribed By:</strong> <?= htmlspecialchars($prescription['username']) ?></p>
            <p><strong>Date:</strong> <?= htmlspecialchars($prescription['prescription_date']) ?></p>
            <p><strong>Notes:</strong><br><?= nl2br(htmlspecialchars($prescription['notes'])) ?></p>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
