<?php
require_once "../config/config.php";
session_start();
require_once "../includes/role_helpers.php";
requireAdmin();
$conn = getDbConnection();

$po_id = intval($_GET['id'] ?? 0);
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['status']) && $po_id > 0) {
        $new_status = $_POST['status'];

        $conn->begin_transaction();
        try {
            $received_date = $new_status === 'Received' ? date('Y-m-d') : null;

            // Update purchase order status and received date
            $stmt = $conn->prepare("UPDATE purchase_orders SET status = ?, received_date = ? WHERE po_id = ?");
            $stmt->bind_param("ssi", $new_status, $received_date, $po_id);
            $stmt->execute();
            $stmt->close();

            // Update stock if received
            if ($new_status === 'Received') {
                // Fetch po items with product_id and quantity
                $items_result = $conn->query("SELECT product_id, quantity FROM po_items WHERE po_id = $po_id");

                // Add quantities to product stock
                while ($item = $items_result->fetch_assoc()) {
                    $product_id = $item['product_id'];
                    $quantity = (int)$item['quantity'];

                    $stmt_update_stock = $conn->prepare("UPDATE products SET stock_quantity = stock_quantity + ? WHERE product_id = ?");
                    $stmt_update_stock->bind_param("ii", $quantity, $product_id);
                    $stmt_update_stock->execute();
                    $stmt_update_stock->close();
                }
            }

            $conn->commit();
            header("Location: view_purchase_order.php?id=$po_id");
            exit;

        } catch (Exception $e) {
            $conn->rollback();
            $error = "Failed to update status and stock: " . $e->getMessage();
        }
    }
}

// Fetch purchase order with supplier and branch details
$po_result = $conn->query("
    SELECT po.*, s.name AS supplier_name, b.branch_name
    FROM purchase_orders po
    JOIN suppliers s ON po.supplier_id = s.supplier_id
    JOIN branches b ON po.branch_id = b.branch_id
    WHERE po.po_id = $po_id
");
$po = $po_result->fetch_assoc();

// Fetch purchase order items with product names
$items_result = $conn->query("
    SELECT pi.*, p.product_name
    FROM po_items pi
    JOIN products p ON pi.product_id = p.product_id
    WHERE pi.po_id = $po_id
");

$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <title>Purchase Order #<?= htmlspecialchars($po['po_id']) ?> Details - Adwenpa Pharma</title>
    <meta charset="UTF-8" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
</head>
<body>
<div class="container my-4">
    <h2>Purchase Order #<?= htmlspecialchars($po['po_id']) ?></h2>
    <p><strong>Supplier:</strong> <?= htmlspecialchars($po['supplier_name']) ?></p>
    <p><strong>Branch:</strong> <?= htmlspecialchars($po['branch_name']) ?></p>
    <p><strong>Order Date:</strong> <?= htmlspecialchars($po['order_date']) ?></p>
    <p><strong>Status:</strong> <?= htmlspecialchars($po['status']) ?></p>

    <?php if ($error): ?>
        <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>

    <form method="post" class="mb-4">
        <label for="status" class="form-label">Change Status</label>
        <select name="status" id="status" class="form-select" onchange="this.form.submit()">
            <option value="Pending" <?= $po['status'] === 'Pending' ? 'selected' : '' ?>>Pending</option>
            <option value="Ordered" <?= $po['status'] === 'Ordered' ? 'selected' : '' ?>>Ordered</option>
            <option value="Received" <?= $po['status'] === 'Received' ? 'selected' : '' ?>>Received</option>
            <option value="Cancelled" <?= $po['status'] === 'Cancelled' ? 'selected' : '' ?>>Cancelled</option>
        </select>
    </form>

    <h3>Order Items</h3>
    <table class="table table-striped">
        <thead>
            <tr>
                <th>Product Name</th>
                <th>Quantity</th>
                <th>Unit Price</th>
                <th>Subtotal</th>
            </tr>
        </thead>
        <tbody>
            <?php while ($item = $items_result->fetch_assoc()): ?>
                <tr>
                    <td><?= htmlspecialchars($item['product_name']) ?></td>
                    <td><?= htmlspecialchars($item['quantity']) ?></td>
                    <td><?= number_format($item['unit_price'], 2) ?></td>
                    <td><?= number_format($item['quantity'] * $item['unit_price'], 2) ?></td>
                </tr>
            <?php endwhile; ?>
        </tbody>
    </table>

    <a href="purchase_orders.php" class="btn btn-secondary">Back to Purchase Orders</a>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
